<?php
	/**
	 * Medodove Social Widget
	 *
	 *
	 * @author 		basictheme
	 * @category 	Widgets
	 * @package 	Medodove/Widgets
	 * @version 	1.0.1
	 * @extends 	WP_Widget
	 */
	add_action('widgets_init', 'dogri_google_map_widget');
	function dogri_google_map_widget() {
		register_widget('dogri_google_map_widget');
	}
	
	
	class Dogri_Google_Map_Widget  extends WP_Widget{
		
		public function __construct(){
			parent::__construct('dogri_google_map_widget',esc_html__('Dogri Google Map Widget','dogri-toolkit'),array(
				'description' => esc_html__('Dogri Google Map Widget','dogri-toolkit'),
			));
		}
		
		public function widget($args,$instance){
			extract($args);
			extract($instance);
		 	print $before_widget; 
		?>

            
            <iframe src="<?php echo $google_map; ?>" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            

	    	<?php print $after_widget; ?>  
		<?php
		}
		

		/**
		 * widget function.
		 *
		 * @see WP_Widget
		 * @access public
		 * @param array $instance
		 * @return void
		 */
		public function form($instance){
			$title  = isset($instance['title'])? $instance['title']:'';
			$google_map  = isset($instance['google_map'])? $instance['google_map']:'';
			
			?>
			<p>
				<label for="title"><?php esc_html_e('Title:','dogri-toolkit'); ?></label>
			</p>
			<input type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  class="widefat" name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

			<p>
				<label for="google_map"><?php esc_html_e('Google Map Code:','dogri-toolkit'); ?></label>
			</p>

            <textarea class="widefat" rows="5" cols="15" id="<?php print $this->get_field_id('google_map'); ?>" value="<?php print $google_map; ?>" name="<?php print $this->get_field_name('google_map'); ?>"><?php echo $google_map; ?></textarea>
		

			
			<?php
		}
				
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance['google_map'] = ( ! empty( $new_instance['google_map'] ) ) ? strip_tags( $new_instance['google_map'] ) : '';

			return $instance;
		}
	}