<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package dogri
 */
get_header();
$blog_column = is_active_sidebar( 'right-sidebar' ) ? 8 : 12 ;
?>

<div class="blog-area section-space">
    <div class="container">
        <div class="row">
            <div class="col-lg-<?php print esc_attr($blog_column); ?> blog-post-items">
                <?php 
					if( have_posts() ):
						?>
							 <div class="result-bar page-header">
								<h1 class="page-title"><?php esc_html_e('Search Results For:','dogri'); ?> <?php print get_search_query(); ?></h1>
							</div>
						<?php 
						while( have_posts() ): the_post();
							get_template_part( 'template-parts/content', 'search' );
						endwhile;
					else:
						get_template_part( 'template-parts/content', 'none' );
					endif; 
				?>
            </div>
			<?php if ( is_active_sidebar( 'right-sidebar' ) ) { ?>
		        <div class="col-lg-4 order-1 order-lg-2">
					<aside class="sidebar">
						<?php get_sidebar(); ?>
					</aside>
	            </div>
			<?php
			}
			?>
        </div>
    </div>
</div>

<?php
get_footer();