<?php

// theme color
function enqueue_custom_color_stylesheet() {
    // Enqueue the main stylesheet
    wp_enqueue_style('dogri-style', get_stylesheet_uri());

    // Get the custom primary color from the customizer
    $primary_color = get_theme_mod('dogri_theme_color', '#eb753b');

    // Enqueue the dynamic CSS file with custom color
    wp_enqueue_style('custom-color-theme', get_template_directory_uri() . '/css/color/theme-color.css');
    wp_add_inline_style('custom-color-theme', '
        
	
        
    .header-top ul.info-list i

        {
        color: ' . esc_attr($primary_color) . ';
        }

        .go-top,
        .dogri_main-header.three ul.menu-left-content li:hover a,
        .dogri_main-header.three .menu-right-content li.user-box:hover,
        .btn-style-two:hover,
        .choose-section .choose-box:before,
        .range-slider .ui-slider .ui-slider-range,
        .cart-button::before,
        .location-filter-card form button,
        .ui-datepicker .ui-datepicker-calendar td:hover,
        .banner-section.two .banner-btn-box,
        .destination-section li.active.filter,
        .btn-style-one,
        .search-popup .search-form fieldset input[type="search"]
        {
        background: ' . esc_attr($primary_color) . ';
        } 


       
        .amazing-deals button.owl-dot.active,
        .search-tour-slide button.owl-dot.active,
        .search-tour-slide.two button.owl-dot.active,
        .feature-section button.owl-dot.active
        {
        background: ' . esc_attr($primary_color) . ';
        } 




        .search-popup .search-form fieldset input[type="search"]:focus{
        border-color: ' . esc_attr($primary_color) . ';
        }
        .dogri_preloader_in:after {
        border-top-color: ' . esc_attr($primary_color) . ';
        }
        
        .destination-section .content-box,
        .dogri-header-sidebar.offcanvas {
            border-left: 5px solid var(--theme-color);
        }
        
        
        .search-tour-slide .icon-box:hover,
        .feature-box:hover,
        .testimonials .reviewer-img:before,
        .testimonial-section-two .gallery-thumbs .swiper-slide-thumb-active .author-image{
            border: 1px dashed ' . esc_attr($primary_color) . ';
        }
        .destination-section li.filter {
            border: 1px solid ' . esc_attr($primary_color) . ';
        }
        
        .range-slider .ui-state-default,
        .range-slider .ui-widget-content .ui-state-default{
            border: 2px solid ' . esc_attr($primary_color) . ';
        }

        
        
        .widget .wp-block-search button,
        .widget .search-form button,
        .basic-pagination .page-numbers:hover,
        .basic-pagination .post-page-numbers:hover,
        .page-links .page-numbers:hover,
        .page-links .post-page-numbers:hover,
        .wp-block-query-pagination-numbers .page-numbers:hover,
        .wp-block-query-pagination-numbers .post-page-numbers:hover,
        .basic-pagination .page-numbers.current,
        .basic-pagination .post-page-numbers.current,
        .page-links .page-numbers.current,
        .page-links .post-page-numbers.current,
        .wp-block-query-pagination-numbers .page-numbers.current,
        .wp-block-query-pagination-numbers .post-page-numbers.current,
        .widget .social-profile a:hover,
        .widget .tagcloud a:hover,
        .news-section .post-info,
        .post-card.style-two .image .icon,
        .author-social-profiles a,
        .widget .wp-block-search button,        
        .widget_promotion .secondary-btn,
        .single-post-item .blog-post-tag .post-tag-list a:hover,
        .latest-comments li .comments-box .comments-text .comment-reply-link:hover{

        background-color: ' . esc_attr($primary_color) . ';

        }

        .single-post-item .post-title:hover a,
        .single-post-item .post-meta span i,
        .blog-post-nav .post-navigation .text span,
        .widget_latest_post ul li .latest-post-desc .latest-post-title a:hover,
        .widget .wp-block-tag-cloud a:hover,
        .widget .wp-block-latest-comments li a:hover,
        .widget .wp-block-latest-posts li a:hover,
        .a.news-btn-1:hover,
        .ul.tags-list-1 li:hover,
        .ul.popular-tag li:hover,
        .news-section .post-info h5:hover > a,
        .single-post-item .social-share a:hover,        
        .single-post-item button.post-gallery-btn:hover,
        .single-post-item button.post-gallery-btn:hover i,
        .single-post-item .post-meta span a:hover,
        .single-post-item .post-meta span a:hover i,
        .author-info .author-post a,
        .post-card.style-one .content .title,
        .post-card.style-two .content .title:hover,
        .post-card.style-four .content .title:hover,
        .post-card.style-three .content .title:hover,
        .post-card.style-four .content .title:hover {

        color: ' . esc_attr($primary_color) . ';

        }

		
    ');
}
add_action('wp_enqueue_scripts', 'enqueue_custom_color_stylesheet');
  