<?php
namespace DogriElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Dogri Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

 
 
class Doctor_Details extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'doctor_details';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Doctor Details', 'dogri-elementor' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'dogri-elementor' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// Tab Start - 1

		$this->start_controls_section(
			'doctor_details',
			[
				'label' => esc_html__( 'Doctor Details', 'dogri-elementor' ),
			]
		);	
		

		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'dogri-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your sub title', 'dogri-elementor' ),
			]
		);
		
	
		$this->add_control(
				'title',
				[
					'label'       => __( 'Title', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter your title', 'dogri-elementor' ),
				]
			);

			$this->add_control(
				'text',
				[
					'label'       => __( 'Description Text', 'theme-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter Your Description', 'theme-elementor' ),
				]
			);

			$this->add_control(
				'image',
					[
					  'label' => __( 'Image', 'theme-elementor' ),
					  'type' => Controls_Manager::MEDIA,
					  'default' => ['url' => Utils::get_placeholder_image_src(),],
					]
			);	
			
			$this->add_control(
				'alt_text',
				[
					'label'       => __( 'Alt text', 'theme-elementor' ),
					'type'        => Controls_Manager::TEXTAREA,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => __( 'Enter Your Description', 'theme-elementor' ),
				]
			);

			$this->add_control(
				'bttn',
				[
					'label'       => __( 'Button', 'dogri-elementor' ),
					'type'        => Controls_Manager::TEXT,
					'dynamic'     => [
						'active' => true,
					],
					'placeholder' => esc_html__( 'Enter your Button Title', 'dogri-elementor' ),
					'default' => esc_html__('Read More', 'dogri-elementor'),
				]
			);	
		
	
		$this->add_control(
				'btnlink',
				[
				  'label' => __( 'Button Url', 'dogri-elementor' ),
				  'type' => Controls_Manager::URL,
				  'placeholder' => __( 'https://your-link.com', 'dogri-elementor' ),
				  'show_external' => true,
				  'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				  ],
				
			   ]
			);			


		$this->end_controls_section();

		
		
		// Tab Start - 2

		$this->start_controls_section(
					'content_section',
					[
						'label' => __( 'Block', 'dogri-elementor' ),
						'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					]
				);
				$this->add_control(
				  'repeat', 
					[
						'type' => Controls_Manager::REPEATER,
						'separator' => 'before',
						'default' => 
							[
								['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
							],
						'fields' => 
							[
								'block_text' =>
								[
									'name' => 'block_text',
									'label' => esc_html__('Text', 'theme-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'theme-elementor')
								],

								'block_icons1' =>
								[
									'name' => 'block_icons1',
									'label' => esc_html__('Enter The icons', 'theme-elementor'),
									'type' => Controls_Manager::ICONS,							
								],

								'block_title' =>
								[
									'name' => 'block_title',
									'label' => esc_html__('Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],
								
								'block_subtitle' =>
								[
									'name' => 'block_subtitle',
									'label' => esc_html__('Sub Title', 'dogri-elementor'),
									'type' => Controls_Manager::TEXTAREA,
									'default' => esc_html__('', 'dogri-elementor')
								],

								'block_btnlink' =>
								[
									'name' => 'block_btnlink',
									'label' => __( 'Url', 'theme-elementor' ),
									'type' => Controls_Manager::URL,
									'placeholder' => __( 'https://your-link.com', 'theme-elementor' ),
									'show_external' => true,
									'default' => [
									'url' => '',
									'is_external' => true,
									'nofollow' => true,
									],
								],

							],
						'title_field' => '{{block_title}}',
					 ]
			);
				
				
		$this->end_controls_section();	


		
		// Tab Start - 3

		$this->start_controls_section(
			'content_section_2',
			[
				'label' => __( 'Block', 'dogri-elementor' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
		  'repeat_2', 
			[
				'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
				'default' => 
					[
						['block_title' => esc_html__('Projects Completed', 'dogri-elementor')],
					],
				'fields' => 
					[					
						

						'block_icons' =>
						[
							'name' => 'block_icons',
							'label' => esc_html__('Enter The icons', 'theme-elementor'),
							'type' => Controls_Manager::ICONS,							
						],

						'block_btnlink1' =>
						[
							'name' => 'block_btnlink1',
							'label' => __( 'Button Url', 'theme-elementor' ),
							'type' => Controls_Manager::URL,
							'placeholder' => __( 'https://your-link.com', 'theme-elementor' ),
							'show_external' => true,
							'default' => [
							  'url' => '',
							  'is_external' => true,
							  'nofollow' => true,
							],
						 ],
					],
				'title_field' => '{{block_title}}',
			 ]
	);
		
		
		$this->end_controls_section();	


		//Section Sub Title	==================		

		$this->start_controls_section(
			'section_subtitle_settings',
			array(
				'label' => __( 'Section Sub Title Setting', 'dogri-elementor' ),			
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);
	
		$this->add_control(
			'show_section_subtitle',
			array(
				'label' => esc_html__( 'Show Sections Sub Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-2' => 'display: {{VALUE}} !important',
				), 
			)
		);
		
		$this->add_control(
			'section_subtitle_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-subtitle-2' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-subtitle-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_control(
			'section_subtitle_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
			'{{WRAPPER}} .section-subtitle-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',		
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
		
			array(
				'name'     => 'section_subtitle_typography',
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-subtitle-2',
			)
		);
		
		
		$this->add_control(
			'section_subtitle_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-2' => 'color: {{VALUE}} !important',
				),
			
			)
		);

		$this->add_control(
			'section_subtitle_bg_color',
			array(
				'label'     => __( 'Background Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_subtitle' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-subtitle-2' => 'background-color: {{VALUE}} !important',
				),
			
			)
		);

		$this->end_controls_section();		
		//End of  Sub Title 	==================	


		// Section Title 	==================
		
		$this->start_controls_section(
			'section_title_settings',
			array(
				'label' => __( 'Section Title Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);		
		
		$this->add_control(
			'show_section_title',
			array(
				'label' => esc_html__( 'Show Section Title', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .section-title' => 'display: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_alingment',
			array(
				'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title' => 'show' ),
				'toggle' => true,
				'selectors' => array(
				
					'{{WRAPPER}} .section-title' => 'text-align: {{VALUE}} !important',
				),
			)
		);
		
		$this->add_control(
			'section_title_margin',
			array(
				'label'     => __( 'Margin', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_control(
			'section_title_padding',
			array(
				'label'     => __( 'Padding', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
			
				'selectors' => array(
					'{{WRAPPER}} .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_typography',
				'condition'    => array( 'show_section_title' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .section-title',
			)
		);
		
		$this->add_control(
			'section_title_color',
			array(
				'label'     => __( 'Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title' => 'show' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .section-title' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();					
		//End of  Title 	==================	


		//Section Title Text==========================
		$this->start_controls_section(
			'section_title_text_settings',
			array(
				'label' => __( 'Section Title Text Setting', 'dogri-elementor' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'show_section_title_text',
			array(
				'label' => esc_html__( 'Show Section Title Text', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'show' => [
						'show' => esc_html__( 'Show', 'dogri-elementor' ),	
						'icon' => 'eicon-check-circle',
					],
					'none' => [
						'none' => esc_html__( 'Hide', 'dogri-elementor' ),
						'icon' => 'eicon-close-circle',
					],
				],
				'default' => 'show',
				'selectors' => array(
					'{{WRAPPER}} .doctor-author-content p' => 'display: {{VALUE}} !important',
				), 
			)
		);

		$this->add_control(
			'section_title_text_alingment',
			array(
				'label' => esc_html__( 'Section Title Text Alignment', 'dogri-elementor' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'dogri-elementor' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'toggle' => true,
				'selectors' => array(
					'{{WRAPPER}} .doctor-author-content p' => 'text-align: {{VALUE}} !important',
				),
			)
		);

		$this->add_control(
			'section_title_text_margin',
			array(
				'label'     => __( 'Section Text Margin', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .doctor-author-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		); 

		$this->add_control(
			'section_title_text_padding',
			array(
				'label'     => __( 'Section Text Padding', 'dogri-elementor' ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' =>  ['px', '%', 'em' ],
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'selectors' => array(
					'{{WRAPPER}} .doctor-author-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
				),
			)
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			array(
				'name'     => 'section_title_text_typography',
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'label'    => __( 'Typography', 'dogri-elementor' ),
				'selector' => '{{WRAPPER}} .doctor-author-content p',
			)
		);

		$this->add_control(
			'section_title_text_color',
			array(
				'label'     => __( 'Section Text Color', 'dogri-elementor' ),
				'condition'    => array( 'show_section_title_text' => 'show' ),
				'separator' => 'after',
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => array(
					'{{WRAPPER}} .doctor-author-content p' => 'color: {{VALUE}} !important',
				),
			)
		);

		$this->end_controls_section();
		//End of Section Title Text=========	

		
	//========== Button with Background ===================================

	$this->start_controls_section(
		'button_control',
		array(
			'label' => __( 'Button Settings', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);

	$this->add_control(
		'show_button',
		array(
			'label' => esc_html__( 'Show Button', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn' => 'display: {{VALUE}} !important',
			),
		)
	);		
	$this->add_control(
		'button_alingment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'condition'    => array( 'show_button' => 'show' ),
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => 'left',
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn' => 'text-align: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_color',
		array(
			'label'     => __( 'Button Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn' => 'color: {{VALUE}} !important',

			),
		)
	);
	$this->add_control(
		'button_bg_color',
		array(
			'label'     => __( 'Background Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn' => 'background: {{VALUE}} !important',
			),
		)
	);	
	$this->add_control(
		'button_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_button' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn:before' => 'background: {{VALUE}} !important',
			),
		)
	);				
	$this->add_control(
		'button_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'button_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' =>  ['px', '%', 'em' ],
			'selectors' => array(
				'{{WRAPPER}}  .fill-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'button_typography',
			'condition'    => array( 'show_button' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}}  .fill-btn',
		)
	);
	$this->add_group_control(
		\Elementor\Group_Control_Border::get_type(),
		array(
			'name' => 'border',
			'condition'    => array( 'show_button' => 'show' ),
			'selector' => '{{WRAPPER}}  .fill-btn',
		)
	);
	$this->add_control(
		'border_radius',
		array(
			'label' => esc_html__( 'Border Radius', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'condition'    => array( 'show_button' => 'show' ),
			'size_units' => [ 'px', '%' ],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1000,
					'step' => 5,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 50,
			],
			'selectors' => [
				'{{WRAPPER}}  .fill-btn' => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		)
	);

	$this->end_controls_section();

	//End of Button	



	// Title 	==================	


	$this->start_controls_section(
		'title_settings',
		array(
			'label' => __( 'Title Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
			
	$this->add_control(
		'show_title',
		array(
			'label' => esc_html__( 'Show Title', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content h5' => 'display: {{VALUE}} !important',
			),   
		)
	);
	
	$this->add_control(
		'title_alignment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_title' => 'show' ),
			'toggle' => true,
			'selectors' => array(
			
				'{{WRAPPER}} .doctor-author-info .content h5' => 'text-align: {{VALUE}}',
			),
		)
	);
	
	$this->add_control(
		'title_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);

	$this->add_control(
		'title_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
		
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'title_typography',
			'condition'    => array( 'show_title' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .doctor-author-info .content h5',
		)
	);
	
	$this->add_control(
		'title_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content h5' => 'color: {{VALUE}} !important',
	
			),
		)
	);

	$this->add_control(
		'title_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_title' => 'show' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content h5:hover' => 'color: {{VALUE}} !important',
	
			),
		)
	);

	$this->end_controls_section();	
	
	
	//End of  Title 	==================


	//Text==========================
	$this->start_controls_section(
		'text_settings',
		array(
			'label' => __( 'Text Setting', 'dogri-elementor' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		)
	);
	
	$this->add_control(
		'show_text',
		array(
			'label' => esc_html__( 'Show Text', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'show' => [
					'show' => esc_html__( 'Show', 'dogri-elementor' ),	
					'icon' => 'eicon-check-circle',
				],
				'none' => [
					'none' => esc_html__( 'Hide', 'dogri-elementor' ),
					'icon' => 'eicon-close-circle',
				],
			],
			'default' => 'show',
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content span' => 'display: {{VALUE}} !important',
			),   
		)
	);
	
	$this->add_control(
		'text_alignment',
		array(
			'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
			'type' => \Elementor\Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__( 'Left', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'dogri-elementor' ),
					'icon' => 'eicon-text-align-right',
				],
			],
			'default' => '',
			'condition'    => array( 'show_text' => 'show' ),
			'toggle' => true,
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content span' => 'text-align: {{VALUE}} !important',
			), 
		)
	);
	
	$this->add_control(
		'text_margin',
		array(
			'label'     => __( 'Margin', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
			'condition'    => array( 'show_text' => 'show' ),
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_control(
		'text_padding',
		array(
			'label'     => __( 'Padding', 'dogri-elementor' ),
			'type'      => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' =>  ['px', '%', 'em' ],
			'condition'    => array( 'show_text' => 'show' ),
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
			),
		)
	);
	
	$this->add_group_control(
		\Elementor\Group_Control_Typography::get_type(),
		array(
			'name'     => 'text_typography',
			'condition'    => array( 'show_text' => 'show' ),
			'label'    => __( 'Typography', 'dogri-elementor' ),
			'selector' => '{{WRAPPER}} .doctor-author-info .content span',
		)
	); 
	
	$this->add_control(
		'text_color',
		array(
			'label'     => __( 'Color', 'dogri-elementor' ),
			'condition'    => array( 'show_text' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content span' => 'color: {{VALUE}} !important',
			),
		)
	);

	$this->add_control(
		'text_hover_color',
		array(
			'label'     => __( 'Hover Color', 'dogri-elementor' ),
			'condition'    => array( 'show_text' => 'show' ),
			'separator' => 'after',
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array(
				'{{WRAPPER}} .doctor-author-info .content span:hover' => 'color: {{VALUE}} !important',
			),
		)
	);

	$this->end_controls_section();
	//End of Text=========	


			//========== icon Settings===================================
				
			$this->start_controls_section(
				'icon_control',
				array(
					'label' => __( 'Icon Settings', 'dogri-elementor' ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				)
			);
			
			$this->add_control(
				'show_icon',
				array(
					'label' => esc_html__( 'Show Icon', 'dogri-elementor' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'show' => [
							'show' => esc_html__( 'Show', 'dogri-elementor' ),	
							'icon' => 'eicon-check-circle',
						],
						'none' => [
							'none' => esc_html__( 'Hide', 'dogri-elementor' ),
							'icon' => 'eicon-close-circle',
						],
					],
					'default' => 'show',
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'display: {{VALUE}} !important',
					),
				)
			);
			
			$this->add_control(
				'icon_alingment',
				array(
					'label' => esc_html__( 'Alignment', 'dogri-elementor' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'condition'    => array( 'show_icon' => 'show' ),
					'options' => [
						'left' => [
							'title' => esc_html__( 'Left', 'dogri-elementor' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'dogri-elementor' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'dogri-elementor' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => '',
					'toggle' => true,
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'text-align: {{VALUE}} !important',
					),
				)
			);	
			
			$this->add_control(
				'icon_color',
				array(
					'label'     => __( ' Color', 'dogri-elementor' ),
					'condition'    => array( 'show_icon' => 'show' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'color: {{VALUE}} !important',

					),
				)
			);
			
			$this->add_control(
				'icon_bgcolor',
				array(
					'label'     => __( 'Background Color', 'dogri-elementor' ),
					'condition'    => array( 'show_icon' => 'show' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'background: {{VALUE}} !important',

					),
				)
			);
			
			
			$this->add_control(
				'icon_hover_color',
				array(
					'label'     => __( ' Hover Color', 'dogri-elementor' ),
					'condition'    => array( 'show_icon' => 'show' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon:hover' => 'color: {{VALUE}} !important',

					),
				)
			);
			
			$this->add_control(
				'icon_hover_bgcolor',
				array(
					'label'     => __( 'Background Hover Color', 'dogri-elementor' ),
					'condition'    => array( 'show_icon' => 'show' ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon:hover' => 'background: {{VALUE}} !important',

					),
				)
			);
			
			$this->add_control(
				'icon_padding',
				array(
					'label'     => __( 'Padding', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'condition'    => array( 'show_icon' => 'show' ),
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					),
				)
			);

			$this->add_control(
				'icon_margin',
				array(
					'label'     => __( 'Margin', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'condition'    => array( 'show_icon' => 'show' ),
					'size_units' =>  ['px', '%', 'em' ],
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					),
				)
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				array(
					'name'     => 'icon_typography',
					'condition'    => array( 'show_icon' => 'show' ),
					'label'    => __( 'Typography', 'dogri-elementor' ),
					'selector' => '{{WRAPPER}} .doctor-author-info .icon',
				)
			);
			
			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				array(
					'name' => 'icon_border',
					'condition'    => array( 'show_icon' => 'show' ),
					'selector' => '{{WRAPPER}} .doctor-author-info .icon',
				)
			);
			
			$this->add_control(
				'icon_border_radius',
				array(
					'label'     => __( 'Icon Border Radius', 'dogri-elementor' ),
					'type'      => \Elementor\Controls_Manager::DIMENSIONS,
					'condition'    => array( 'show_icon' => 'show' ),
					'size_units' =>  ['px', '%', 'em' ],
				
					'selectors' => array(
						'{{WRAPPER}} .doctor-author-info .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',
					),
				)
			);


			$this->end_controls_section();		
			
			//End of icon



	
		}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		?>

<?php
	  echo '
	 <script>
 jQuery(document).ready(function($) {

//write js code under this line 


//write code above the line 

  });
</script>';


?>

      <!-- Doctor area start -->
      <section class="doctor-area section-space">
         <div class="container">
            <div class="row gy-50 align-items-center">
               <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="doctor-author-thumb-wrapper wow fadeInLeft p-relative" data-wow-delay="0.3s">

                     <div class="doctor-author-thumb w-img">
						<?php  if ( !empty(esc_url($settings['image']['id']) )) : ?>   
							<img src="<?php echo wp_get_attachment_url($settings['image']['id']);?>" alt="<?php echo esc_attr($settings['alt_text']);?>"/>
						<?php endif;?>
                     </div>
					 
                     <div class="author-social">
					 	<?php foreach($settings['repeat_2'] as $item):?>
                        	<a href="<?php echo esc_url($item['block_btnlink1']['url']);?>"><i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons']['value']));?>"></i></a>
						<?php endforeach; ?>
                     </div>
                  </div>
               </div>
               <div class="col-xxl-6 col-xl-6 col-lg-6">
                  <div class="doctor-author-content wow fadeInRight" data-wow-delay="0.3s">
                     <div class="section-title-wrapper-2 mb-30">
                        <span class="section-subtitle-2 mb-20"><?php echo $settings['subtitle'];?></span>
                        <h2 class="section-title"><?php echo $settings['title'];?></h2>
                     </div>
                     <p><?php echo $settings['text'];?></p>
                     <div class="doctor-author mt-30 mb-40">
						<?php foreach($settings['repeat'] as $item):?>
                        <div class="doctor-author-info">
                           <div class="icon">
						   		<i class="<?php echo str_replace("icon ", " ", esc_attr( $item['block_icons1']['value']));?>"></i>
                           </div>
                           <div class="content">
                              <h5><?php echo wp_kses($item['block_title'], $allowed_tags);?></h5>
                              <span><a href="<?php echo esc_url($item['block_btnlink']['url']);?>"><?php echo wp_kses($item['block_subtitle'], $allowed_tags);?></a></span>
                           </div>
                        </div>
						<?php endforeach; ?>
                     </div>
                     <a href="<?php echo esc_url($settings['btnlink']['url']);?>" class="fill-btn">
                        <span class="fill-btn-inner">
                           <span class="fill-btn-normal"><?php echo $settings['bttn'];?><i
                                 class="fa-regular fa-angle-right"></i></span>
                           <span class="fill-btn-hover"><?php echo $settings['bttn'];?><i class="fa-regular fa-angle-right"></i></span>
                        </span>
                     </a>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Doctor area end -->


             
		<?php 
	}


}